/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wiki;

import com.sun.star.awt.XAnimation;
import com.sun.star.awt.XControl;
import com.sun.star.awt.XControlContainer;
import com.sun.star.awt.XControlModel;
import com.sun.star.awt.XDialog;
import com.sun.star.awt.XDialogEventHandler;
import com.sun.star.awt.XDialogProvider2;
import com.sun.star.awt.XTopWindow;
import com.sun.star.awt.XTopWindowListener;
import com.sun.star.awt.XWindow;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.XNameContainer;
import com.sun.star.lang.EventObject;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import com.sun.star.wiki.Helper;
import com.sun.star.wiki.Settings;

public class WikiDialog
implements XDialogEventHandler,
XTopWindowListener {
    protected XComponentContext m_xContext;
    private XControlContainer m_xControlContainer;
    protected XDialog m_xDialog;
    private String[] m_aMethods;
    protected boolean m_bAction = false;
    protected Settings m_aSettings;
    protected Thread m_aThread;
    protected boolean m_bThreadFinished = false;

    public WikiDialog(XComponentContext c, String DialogURL) {
        this.m_xContext = c;
        XMultiComponentFactory xMCF = this.m_xContext.getServiceManager();
        this.m_aSettings = Settings.getSettings(this.m_xContext);
        try {
            Object obj = xMCF.createInstanceWithContext("com.sun.star.awt.DialogProvider2", this.m_xContext);
            XDialogProvider2 xDialogProvider = (XDialogProvider2)UnoRuntime.queryInterface(XDialogProvider2.class, (Object)obj);
            this.m_xDialog = xDialogProvider.createDialogWithHandler(DialogURL, (Object)this);
            this.m_xControlContainer = (XControlContainer)UnoRuntime.queryInterface(XControlContainer.class, (Object)this.m_xDialog);
            XTopWindow xTopWindow = (XTopWindow)UnoRuntime.queryInterface(XTopWindow.class, (Object)this.m_xDialog);
            if (xTopWindow != null) {
                xTopWindow.addTopWindowListener((XTopWindowListener)this);
            }
        }
        catch (com.sun.star.uno.Exception ex) {
            ex.printStackTrace();
        }
    }

    public synchronized void ThreadStop(boolean bSelf) {
        if (bSelf || this.m_aThread != null && !this.m_bThreadFinished) {
            try {
                Helper.AllowConnection(bSelf);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.m_aThread = null;
        this.m_bThreadFinished = true;
    }

    protected void setMethods(String[] Methods) {
        this.m_aMethods = Methods;
    }

    public boolean show() {
        this.m_bThreadFinished = false;
        if (this.m_xDialog != null) {
            this.m_xDialog.execute();
        }
        return this.m_bAction;
    }

    public String[] getSupportedMethodNames() {
        return this.m_aMethods;
    }

    public boolean callHandlerMethod(XDialog xDialog, Object EventObject2, String MethodName) {
        return true;
    }

    public void SetTitle(String sTitle) throws Exception {
        WikiDialog.SetTitle(this.m_xDialog, sTitle);
    }

    private static void SetTitle(XDialog xDialog, String sTitle) throws Exception {
        XPropertySet xPropSet;
        if (xDialog == null || sTitle == null) {
            return;
        }
        XControl xDialogControl = (XControl)UnoRuntime.queryInterface(XControl.class, (Object)xDialog);
        if (xDialogControl != null && (xPropSet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xDialogControl.getModel())) != null) {
            xPropSet.setPropertyValue("Title", (Object)sTitle);
        }
    }

    protected XPropertySet GetPropSet(String sControl) {
        return WikiDialog.GetPropSet(this.m_xControlContainer, sControl);
    }

    private static XPropertySet GetPropSet(XControlContainer xControlContainer, String sControl) {
        XPropertySet xPS = null;
        if (xControlContainer != null && sControl != null) {
            XControl xControl = xControlContainer.getControl(sControl);
            xPS = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xControl.getModel());
        }
        if (xPS == null) {
            throw new RuntimeException();
        }
        return xPS;
    }

    protected void InsertThrobber(int X, int Y, int Width, int Height) {
        try {
            XControlModel xThrobberModel;
            XPropertySet xThrobberProps;
            XMultiServiceFactory xDialogFactory;
            XControl xDialogControl = (XControl)UnoRuntime.queryInterface(XControl.class, (Object)this.m_xDialog);
            XControlModel xDialogModel = null;
            if (xDialogControl != null) {
                xDialogModel = xDialogControl.getModel();
            }
            if ((xDialogFactory = (XMultiServiceFactory)UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)xDialogModel)) != null && (xThrobberProps = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)(xThrobberModel = (XControlModel)UnoRuntime.queryInterface(XControlModel.class, (Object)xDialogFactory.createInstance("com.sun.star.awt.SpinningProgressControlModel"))))) != null) {
                xThrobberProps.setPropertyValue("Name", (Object)"WikiThrobber");
                xThrobberProps.setPropertyValue("PositionX", (Object)X);
                xThrobberProps.setPropertyValue("PositionY", (Object)Y);
                xThrobberProps.setPropertyValue("Width", (Object)Width);
                xThrobberProps.setPropertyValue("Height", (Object)Height);
                XNameContainer xDialogContainer = (XNameContainer)UnoRuntime.queryInterface(XNameContainer.class, (Object)xDialogModel);
                xDialogContainer.insertByName("WikiThrobber", (Object)xThrobberModel);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.SetThrobberVisible(false);
    }

    public void SetThrobberActive(boolean bActive) {
        if (this.m_xControlContainer != null) {
            try {
                XAnimation xThrobber = (XAnimation)UnoRuntime.queryInterface(XAnimation.class, (Object)this.m_xControlContainer.getControl("WikiThrobber"));
                if (xThrobber != null) {
                    if (bActive) {
                        xThrobber.startAnimation();
                    } else {
                        xThrobber.stopAnimation();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void SetThrobberVisible(boolean bVisible) {
        if (this.m_xControlContainer != null) {
            try {
                XWindow xWindow = (XWindow)UnoRuntime.queryInterface(XWindow.class, (Object)this.m_xControlContainer.getControl("WikiThrobber"));
                if (xWindow != null) {
                    xWindow.setVisible(bVisible);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void SetFocusTo(String aControl) {
        if (this.m_xControlContainer != null) {
            try {
                XWindow xWindow = (XWindow)UnoRuntime.queryInterface(XWindow.class, (Object)this.m_xControlContainer.getControl(aControl));
                if (xWindow != null) {
                    xWindow.setFocus();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void DisposeDialog() {
        Helper.Dispose(this.m_xDialog);
    }

    public void windowOpened(EventObject e) {
    }

    public void windowClosing(EventObject e) {
    }

    public void windowClosed(EventObject e) {
    }

    public void windowMinimized(EventObject e) {
    }

    public void windowNormalized(EventObject e) {
    }

    public void windowActivated(EventObject e) {
    }

    public void windowDeactivated(EventObject e) {
    }

    public void disposing(EventObject e) {
    }
}

