/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.text;

import com.sun.star.container.XIndexAccess;
import com.sun.star.container.XNameAccess;
import com.sun.star.container.XNamed;
import com.sun.star.frame.XFrame;
import com.sun.star.lang.Locale;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.table.XCellRange;
import com.sun.star.text.XSimpleText;
import com.sun.star.text.XTextContent;
import com.sun.star.text.XTextDocument;
import com.sun.star.text.XTextTable;
import com.sun.star.text.XTextTablesSupplier;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.util.XNumberFormatsSupplier;
import com.sun.star.view.XSelectionSupplier;
import com.sun.star.wizards.common.Desktop;
import com.sun.star.wizards.common.Helper;
import com.sun.star.wizards.common.NumberFormatter;

public class TextTableHandler {
    public XTextTablesSupplier xTextTablesSupplier;
    private XTextDocument xTextDocument;
    private NumberFormatter oNumberFormatter;

    public TextTableHandler(XTextDocument xTextDocument) {
        try {
            this.xTextDocument = xTextDocument;
            this.xTextTablesSupplier = (XTextTablesSupplier)UnoRuntime.queryInterface(XTextTablesSupplier.class, (Object)xTextDocument);
            UnoRuntime.queryInterface(XSimpleText.class, (Object)xTextDocument.getText());
            XNumberFormatsSupplier xNumberFormatsSupplier = (XNumberFormatsSupplier)UnoRuntime.queryInterface(XNumberFormatsSupplier.class, (Object)xTextDocument);
            Locale aCharLocale = (Locale)Helper.getUnoStructValue(xTextDocument, "CharLocale");
            this.oNumberFormatter = new NumberFormatter(xNumberFormatsSupplier, aCharLocale);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    public NumberFormatter getNumberFormatter() {
        return this.oNumberFormatter;
    }

    public XTextTable getByName(String _sTableName) {
        XTextTable xTextTable = null;
        try {
            XNameAccess xAllTextTables = this.xTextTablesSupplier.getTextTables();
            if (xAllTextTables.hasByName(_sTableName)) {
                Object oTable = xAllTextTables.getByName(_sTableName);
                xTextTable = (XTextTable)UnoRuntime.queryInterface(XTextTable.class, (Object)oTable);
            }
        }
        catch (com.sun.star.uno.Exception exception) {
            exception.printStackTrace(System.err);
        }
        return xTextTable;
    }

    public XTextTable getlastTextTable() {
        try {
            XIndexAccess xAllTextTables = (XIndexAccess)UnoRuntime.queryInterface(XIndexAccess.class, (Object)this.xTextTablesSupplier.getTextTables());
            int MaxIndex = xAllTextTables.getCount() - 1;
            Object oTable = xAllTextTables.getByIndex(MaxIndex);
            return (XTextTable)UnoRuntime.queryInterface(XTextTable.class, (Object)oTable);
        }
        catch (com.sun.star.uno.Exception exception) {
            exception.printStackTrace(System.err);
            return null;
        }
    }

    public void removeAllTextTables() {
        try {
            XIndexAccess xAllTextTables = (XIndexAccess)UnoRuntime.queryInterface(XIndexAccess.class, (Object)this.xTextTablesSupplier.getTextTables());
            int TextTableCount = xAllTextTables.getCount();
            for (int i = TextTableCount - 1; i >= 0; --i) {
                this.removeTextTable(xAllTextTables.getByIndex(i));
            }
        }
        catch (com.sun.star.uno.Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    public void removeLastTextTable() {
        try {
            XIndexAccess xAllTextTables = (XIndexAccess)UnoRuntime.queryInterface(XIndexAccess.class, (Object)this.xTextTablesSupplier.getTextTables());
            Object oTextTable = xAllTextTables.getByIndex(xAllTextTables.getCount() - 1);
            this.removeTextTable(oTextTable);
        }
        catch (com.sun.star.uno.Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    private void removeTextTable(Object oTextTable) {
        try {
            XTextContent xTextContentTable = (XTextContent)UnoRuntime.queryInterface(XTextContent.class, (Object)oTextTable);
            this.xTextDocument.getText().removeTextContent(xTextContentTable);
        }
        catch (com.sun.star.uno.Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    public void removeTextTablebyName(String TableName) {
        try {
            XNameAccess xAllTextTables = this.xTextTablesSupplier.getTextTables();
            if (xAllTextTables.hasByName(TableName)) {
                this.removeTextTable(xAllTextTables.getByName(TableName));
            }
        }
        catch (com.sun.star.uno.Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    public void renameTextTable(String OldTableName, String NewTableName) {
        try {
            XNameAccess xTextTableNames = this.xTextTablesSupplier.getTextTables();
            if (xTextTableNames.hasByName(OldTableName)) {
                Object oTextTable = xTextTableNames.getByName(OldTableName);
                XNamed xTextTableName = (XNamed)UnoRuntime.queryInterface(XNamed.class, (Object)oTextTable);
                xTextTableName.setName(NewTableName);
            }
        }
        catch (com.sun.star.uno.Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    public void adjustOptimalTableWidths(XMultiServiceFactory _xMSF, XTextTable xTextTable) {
        try {
            XFrame xFrame = this.xTextDocument.getCurrentController().getFrame();
            int ColCount = xTextTable.getColumns().getCount();
            XCellRange xCellRange = (XCellRange)UnoRuntime.queryInterface(XCellRange.class, (Object)xTextTable);
            XCellRange xLocCellRange = xCellRange.getCellRangeByPosition(0, 0, ColCount - 1, 1);
            short iHoriOrient = AnyConverter.toShort((Object)Helper.getUnoPropertyValue(xTextTable, "HoriOrient"));
            XSelectionSupplier xSelection = (XSelectionSupplier)UnoRuntime.queryInterface(XSelectionSupplier.class, (Object)this.xTextDocument.getCurrentController());
            xSelection.select((Object)xLocCellRange);
            Desktop.dispatchURL(_xMSF, ".Uno:DistributeColumns", xFrame);
            Desktop.dispatchURL(_xMSF, ".Uno:SetOptimalColumnWidth", xFrame);
            Helper.setUnoPropertyValue(xTextTable, "HoriOrient", iHoriOrient);
        }
        catch (com.sun.star.uno.Exception exception) {
            exception.printStackTrace(System.err);
        }
    }
}

