/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.common;

import com.sun.star.beans.XPropertySet;
import com.sun.star.lang.Locale;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.util.XNumberFormatTypes;
import com.sun.star.util.XNumberFormats;
import com.sun.star.util.XNumberFormatsSupplier;
import com.sun.star.util.XNumberFormatter;
import com.sun.star.wizards.common.Helper;
import java.util.Calendar;
import java.util.Date;

public class NumberFormatter {
    private int iDateFormatKey = -1;
    private int iDateTimeFormatKey = -1;
    private int iNumberFormatKey = -1;
    private int iTextFormatKey = -1;
    private int iTimeFormatKey = -1;
    private int iLogicalFormatKey = -1;
    private long lDateCorrection;
    private XNumberFormatter xNumberFormatter;
    private XNumberFormats xNumberFormats;
    private XNumberFormatTypes xNumberFormatTypes;
    private XPropertySet xNumberFormatSettings;
    private final Locale aLocale;
    private static final Locale enLocale = new Locale("en", "US", "");

    public NumberFormatter(XMultiServiceFactory _xMSF, XNumberFormatsSupplier _xNumberFormatsSupplier, Locale _aLocale) throws Exception {
        this.aLocale = _aLocale;
        Object oNumberFormatter = _xMSF.createInstance("com.sun.star.util.NumberFormatter");
        this.xNumberFormats = _xNumberFormatsSupplier.getNumberFormats();
        this.xNumberFormatSettings = _xNumberFormatsSupplier.getNumberFormatSettings();
        this.xNumberFormatter = (XNumberFormatter)UnoRuntime.queryInterface(XNumberFormatter.class, (Object)oNumberFormatter);
        this.xNumberFormatter.attachNumberFormatsSupplier(_xNumberFormatsSupplier);
        this.xNumberFormatTypes = (XNumberFormatTypes)UnoRuntime.queryInterface(XNumberFormatTypes.class, (Object)this.xNumberFormats);
    }

    public NumberFormatter(XNumberFormatsSupplier _xNumberFormatsSupplier, Locale _aLocale) throws Exception {
        this.aLocale = _aLocale;
        this.xNumberFormats = _xNumberFormatsSupplier.getNumberFormats();
        this.xNumberFormatSettings = _xNumberFormatsSupplier.getNumberFormatSettings();
        this.xNumberFormatTypes = (XNumberFormatTypes)UnoRuntime.queryInterface(XNumberFormatTypes.class, (Object)this.xNumberFormats);
    }

    public double convertStringToNumber(int _nkey, String _sString) throws Exception {
        return this.xNumberFormatter.convertStringToNumber(_nkey, _sString);
    }

    public void setNullDateCorrection(long dateCorrection) {
        this.lDateCorrection = dateCorrection;
    }

    public int defineNumberFormat(String _FormatString) {
        try {
            int NewFormatKey = this.xNumberFormats.queryKey(_FormatString, this.aLocale, true);
            if (NewFormatKey == -1) {
                NewFormatKey = this.xNumberFormats.addNewConverted(_FormatString, enLocale, this.aLocale);
            }
            return NewFormatKey;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            return -1;
        }
    }

    private int defineNumberFormat(String _FormatString, Locale _aLocale) {
        try {
            int NewFormatKey = this.xNumberFormats.queryKey(_FormatString, _aLocale, true);
            if (NewFormatKey == -1) {
                NewFormatKey = this.xNumberFormats.addNew(_FormatString, _aLocale);
            }
            return NewFormatKey;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            return -1;
        }
    }

    public void setNumberFormat(XInterface _xFormatObject, int _FormatKey, NumberFormatter _oNumberFormatter) {
        block5: {
            try {
                XPropertySet xNumberFormat = _oNumberFormatter.xNumberFormats.getByKey(_FormatKey);
                String FormatString = AnyConverter.toString((Object)Helper.getUnoPropertyValue(xNumberFormat, "FormatString"));
                Locale oLocale = (Locale)Helper.getUnoPropertyValue(xNumberFormat, "Locale");
                int NewFormatKey = this.defineNumberFormat(FormatString, oLocale);
                XPropertySet xPSet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)_xFormatObject);
                if (xPSet.getPropertySetInfo().hasPropertyByName("FormatsSupplier")) {
                    xPSet.setPropertyValue("FormatsSupplier", (Object)_oNumberFormatter.xNumberFormatter.getNumberFormatsSupplier());
                }
                if (xPSet.getPropertySetInfo().hasPropertyByName("NumberFormat")) {
                    xPSet.setPropertyValue("NumberFormat", (Object)NewFormatKey);
                    break block5;
                }
                if (xPSet.getPropertySetInfo().hasPropertyByName("FormatKey")) {
                    xPSet.setPropertyValue("FormatKey", (Object)NewFormatKey);
                    break block5;
                }
                throw new Exception();
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
            }
        }
    }

    public long getNullDateCorrection() {
        com.sun.star.util.Date dNullDate = (com.sun.star.util.Date)Helper.getUnoStructValue(this.xNumberFormatSettings, "NullDate");
        long lNullDate = Helper.convertUnoDatetoInteger(dNullDate);
        Calendar oCal = Calendar.getInstance();
        oCal.set(1900, 1, 1);
        Date dTime = oCal.getTime();
        long lTime = dTime.getTime();
        long lDBNullDate = lTime / 86400000L;
        this.lDateCorrection = lDBNullDate - lNullDate;
        return this.lDateCorrection;
    }

    public int setBooleanReportDisplayNumberFormat() {
        String FormatString = "[=1]\"\u2611\";[=0]\"\ue470\";0";
        this.iLogicalFormatKey = this.xNumberFormats.queryKey(FormatString, this.aLocale, true);
        try {
            if (this.iLogicalFormatKey == -1) {
                this.iLogicalFormatKey = this.xNumberFormats.addNew(FormatString, this.aLocale);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.iLogicalFormatKey = this.xNumberFormatTypes.getStandardFormat((short)1024, this.aLocale);
        }
        return this.iLogicalFormatKey;
    }

    public int getDateFormatKey() {
        if (this.iDateFormatKey == -1) {
            this.iDateFormatKey = this.xNumberFormatTypes.getStandardFormat((short)2, this.aLocale);
        }
        return this.iDateFormatKey;
    }

    public int getDateTimeFormatKey() {
        if (this.iDateTimeFormatKey == -1) {
            this.iDateTimeFormatKey = this.xNumberFormatTypes.getStandardFormat((short)6, this.aLocale);
        }
        return this.iDateTimeFormatKey;
    }

    public int getLogicalFormatKey() {
        if (this.iLogicalFormatKey == -1) {
            this.iLogicalFormatKey = this.xNumberFormatTypes.getStandardFormat((short)1024, this.aLocale);
        }
        return this.iLogicalFormatKey;
    }

    public int getNumberFormatKey() {
        if (this.iNumberFormatKey == -1) {
            this.iNumberFormatKey = this.xNumberFormatTypes.getStandardFormat((short)16, this.aLocale);
        }
        return this.iNumberFormatKey;
    }

    public int getTextFormatKey() {
        if (this.iTextFormatKey == -1) {
            this.iTextFormatKey = this.xNumberFormatTypes.getStandardFormat((short)256, this.aLocale);
        }
        return this.iTextFormatKey;
    }

    public int getTimeFormatKey() {
        if (this.iTimeFormatKey == -1) {
            this.iTimeFormatKey = this.xNumberFormatTypes.getStandardFormat((short)4, this.aLocale);
        }
        return this.iTimeFormatKey;
    }
}

